clear all
clc
close all


%% Create Data

load AALabData
Row=row;
Freq=freq;

load AANewData

Row=[Row;row'];
Freq=[Freq;freq];

load AAMTData

Row=[Row;row];
Freq=[Freq;freq];

%% Analysis

n=length(Row); %number of games
K=3;

for i=1:n
    m=Freq(i,4);
    t1=Freq(i,1);
    t2=Freq(i,1)+Freq(i,2);
    
    c = cvpartition(m,'KFold',K);
    
    for k=1:K
        indtrain=find(c.training(k));
        indtest=find(c.test(k));
        
        %Train Counts
        traincount(i,1)=length(find(indtrain<=t1));
        traincount(i,2)=length(find(indtrain>t1 & indtrain<=t2));
        traincount(i,3)=length(find(indtrain>t2));
        [~,modaltrain(i)]=max(traincount(i,:));
        
        %Test Counts
        testcount(i,1)=length(find(indtest<=t1));
        testcount(i,2)=length(find(indtest>t1 & indtest<=t2));
        testcount(i,3)=length(find(indtest>t2));
        [~,modaltest(i)]=max(testcount(i,:));
        
        correct(i,k)=double(logical(modaltrain(i)==modaltest(i)));
        clear indtrain indtest
        
    end
end

mean(mean(correct))
sqrt(var(mean(correct)))